#define HID_REPORT_LENGTH sizeof(HID_REPORT)

code BYTE HID_REPORT[]=
  { 0x05,0x0C,                                   // USAGE_PAGE ( Consumer Devices )
    0x09,0x01,                                   // USAGE ( Consumer Control )
    0xA1,0x01,                                   // Collection ( Application )
      0x09,0xE9,                                 // USAGE ( Volume Up )
      0x09,0xEA,                                 // USAGE ( Volume Down )
      0x09,0xE2,                                 // USAGE ( Mute )      
      0x09,0xCD,                                 // USAGE ( Play/Pause )
      0x09,0xB5,                                 // USAGE ( Next Track )
      0x09,0xB6,                                 // USAGE ( Previous Track )
      0x09,0xB7,                                 // USAGE ( Stop )
      0x0A,0x83,0x01,                            // USAGE ( Call Media Play )
      0x15,0x00,                                 // Logical_Minimum ( 0 )
      0x25,0x01,                                 // Logical_Maxmum ( 1 )
      0x95,0x08,                                 // Report_Count ( 8 )
      0x75,0x01,                                 // Report_Size ( 1 )
      0x81,0x42,                                 // Input ( Data , Var , Abs , Null )
      0x09,0x00,                                 // Usage (Unassigned)
      0x95,DFU_MAX-1,                            // Report_Count ( DFU_MAX-1 )
      0x75,0x08,                                 // Report_Size ( 8 )
      0x81,0x02,                                 // Input ( Data , Ary , Abs )
      0x09,0x00,                                 // Usage (Unassigned)
      0x95,DFU_MAX,                              // Report_Count ( DFU_MAX )
      0x75,0x08,                                 // Report_Size ( 8 )
      0xB1,0x02,                                 // Feature ( Data , Ary , Abs )
    0xC0                                         // End_Collection
  };


//-----Device Descriptor-----//
code BYTE DEVICE_DESCRIPTOR[]=
  { 0x12,                                        // 0:  bLength
    0x01,                                        // 1:  bDescriptorType (Device)
    0x10,                                        // 2:  bcdUSB(LSB)
    0x01,                                        //     bcdUSB(MSB)
    0x00,                                        // 4:  bDeviceClass
    0x00,                                        // 5:  bDevice SubClass
    0x00,                                        // 6:  bDeviceProtocol
    DFU_MAX,                                     // 7:  bMaxPacketSize
    0x8C,                                        // 8:  idVendor(LSB)
    0x0B,                                        //     idVendor(MSB)
    0x0D,                                        // 10: idProduct(LSB)
    0x00,                                        //     idProduct(MSB)
    0x00,                                        // 12: bcdDevice(LSB)
    0x01,                                        //     bcdDevice(MSB)
    0x01,                                        // 14: iManufacture (String Index)
    0x02,                                        // 15: iProduct     (String Index)
    0x00,                                        // 16: iSerialNumber(String Index)
    0x01                                         // 17: bNumConfigurations
  };


//-----Configuration Descriptor-----//
code BYTE CONGFIGURATION_DESCRIPTOR[]=
  { 0x09,                                        // 0:  bLength
    0x02,                                        // 1:  bDescriptorType
    0xF8,                                        // 2:  wTotalLength(LSB)(All Descriptor ,
    0x00,                                        // 3:  wTotalLength(MSB)(Exclude "String")
    0x04,                                        // 4:  bNumInterface
    0x01,                                        // 5:  bConfigurationValue
    0x00,                                        // 6:  iConfiguration (String Index)
#ifdef SELF_POWER
    0xC0,                                        // 7:  bmAttributes (Bus power & Remote wakeup)
                                                 //     D7:      Reserved (Set to one)
                                                 //     D6:      Self Powered
                                                 //     D5:      Remote Wakeup
                                                 //     D4..0:   Reserved (Reset to 0)
    0x32                                         // 8:  Power    (100mA)
#endif
#ifdef BUS_POWER_500MA
    0x80,                                        // 7:  bmAttributes (Bus power & Remote wakeup)
                                                 //     D7:      Reserved (Set to one)
                                                 //     D6:      Self Powered
                                                 //     D5:      Remote Wakeup
                                                 //     D4..0:   Reserved (Reset to 0)
    0xFA                                         // 8:  Power    (500mA)
#endif
#ifdef BUS_POWER_100MA
    0x80,                                        // 7:  bmAttributes (Bus power & Remote wakeup)
                                                 //     D7:      Reserved (Set to one)
                                                 //     D6:      Self Powered
                                                 //     D5:      Remote Wakeup
                                                 //     D4..0:   Reserved (Reset to 0)
    0x32                                         // 8:  Power    (100mA)
#endif
  };


//-----HID Interface Descriptor-----//
code BYTE HID_INTERFACE_DESCRIPTOR[]=
  { 0x09,                                        // 0:  bLength
    0x04,                                        // 1:  bDescriptorType
    0x00,                                        // 2:  bInterfaceNumber
    0x00,                                        // 3:  bAlternateSetting
    0x01,                                        // 4:  bNumEndpoints
    0x03,                                        // 5:  bInterfaceClass
    0x00,                                        // 6:  bInterfaceSubClass
    0x00,                                        // 7:  bInterfaceProtocol
    0x00                                         // 8:  iInterface         (String Index)
  };
  

//-----HID Descriptor-----//
code BYTE HID_DESCRIPTOR[]=
  { 0x09,                                        // 0:  bLength
    0x21,                                        // 1:  bDescriptorType
    0x00,                                        // 2:  bcdHIDClassL
    0x01,                                        // 3:  bcdHIDClassH
    0x00,                                        // 4:  Hardware Target Country
    0x01,                                        // 5:  Number of HID class descriptor to follow
    0x22,                                        // 6:  Report descriptor type
    HID_REPORT_LENGTH,                           // 7:  Total length of Report descriptor L
    0x00                                         // 8:  Total length of Report descriptor H
  };


code BYTE HID_ENDPOINT1_DESCRIPTOR[]=
  { 0x07,           				 // 0:  bLength
    0x05,       				 // 1:  bDescriptorType
    0x81,       				 // 2:  bEndpointerAddress
               					 //      D7:     Direction(0:OUT, 1:IN)
               					 //      D6..4:  Reserved (reset to 0)
                				 //      D3..0:  Endpoint Number(0000-1111)
    0x03,       				 // 3:  bmAttributes
                				 //      D7..2:  Reserved (reset to 0)
                				 //      D1..0:  Transfer Type(00:Control,01:Bulk,02:Iso,03:Int)
    DFU_MAX,                                     // 4:  wPacketSize(LSB)
    0x00,       				 //     wPacketSize(MSB)
    0x10        				 // 6:  bInterval (Unit 1ms)
                				 //      Isochronous Endpoint: 01
                				 //      Interrupt Endpoint: 01-ff
  };

//-----Standard AC Interface Descriptor-----//
code BYTE STD_AC_INTERFACE_DESCRIPTOR[]=
  { 0x09,                                        // 0:  bLength
    0x04,                                        // 1:  bDescriptorType
    0x01,                                        // 2:  bInterfaceNumber
    0x00,                                        // 3:  bAlternateSetting
    0x00,                                        // 4:  bNumEndpoints
    0x01,                                        // 5:  bInterfaceClass    (AUDIO)
    0x01,                                        // 6:  bInterfaceSubClass (AUDIO-CONTROL)
    0x00,                                        // 7:  bInterfaceProtocol (Unused)
    0x00                                         // 8:  iInterface         (String Index)
  };


//-----Class_Specific AC Interface Descriptor-----//
code BYTE CS_AC_INTERFACE_DESCRIPTOR[]=
  { 0x0A,                                        // 0:  bLength
    0x24,                                        // 1:  bDescriptorType    (CS_INTERFACE)
    0x01,                                        // 2:  bDescriptorSubType (HEADER)
    0x00,                                        // 3:  bcdADC(LSB)
    0x01,                                        //     bcdADC(MSB)    
    0x65,                                        // 5:  wTotalLength(LSB)  [H+I+F+M+O]
    0x00,                                        // 6:  wTotalLength(MSB)
    0x02,                                        // 7:  bInCollection,Number Of Streaming Interface
    0x02,                                        // 8:  bInterfaceNr
    0x03                                         // 8:  bInterfaceNr
  };


//-----Input Terminal Descriptor-----//
code BYTE INPUT_TERMINAL_USB_DESCRIPTOR[]=
  { 0x0C,                                        // 0:  bLength
    0x24,                                        // 1:  bDescriptorType    (CS_INTERFACE)
    0x02,                                        // 2:  bDescriptorSubType (INPUT_TERMINAL)
    0x01,                                        // 3:  bTerminalID
    0x01,                                        // 4:  bTerminalType(LSB) (USB Streaming)
    0x01,                                        // 5:  bTerminalType(MSB)
    0x00,                                        // 6:  bAssocTerminal     (No association)
    0x02,                                        // 7:  bNrChannels        (Two Channel)
    0x03,                                        // 8:  wChannelConfig(LSB)(Left , Right)
    0x00,                                        // 9:  wChannelConfig(MSB)
    0x00,                                        // A:  iChannelName       (Unused)
    0x00                                         // B:  iTerminal          (Unused)
  };

//-----Input Terminal Descriptor-----//
code BYTE INPUT_TERMINAL_MICROPHONE_DESCRIPTOR[]=
  { 0x0C,                                        // 0:  bLength
    0x24,                                        // 1:  bDescriptorType    (CS_INTERFACE)
    0x02,                                        // 2:  bDescriptorSubType (INPUT_TERMINAL)
    0x02,                                        // 3:  bTerminalID
    0x01,                                        // 4:  bTerminalType(LSB) (Microphone Streaming)
    0x02,                                        // 5:  bTerminalType(MSB)
    0x00,                                        // 6:  bAssocTerminal     (No association)
    0x01,                                        // 7:  bNrChannels        (One Channel)
    0x00,                                        // 8:  wChannelConfig(LSB)(Mono set)
    0x00,                                        // 9:  wChannelConfig(MSB)
    0x00,                                        // A:  iChannelName       (Unused)
    0x00                                         // B:  iTerminal          (Unused)
  };

//-----Output Terminal Descriptor-----//
code BYTE OUTPUT_TERMINAL_SPEAKER_DESCRIPTOR[]=
  { 0x09,                                        // 0:  bLength
    0x24,                                        // 1:  bDescriptorType    (CS_INTERFACE)
    0x03,                                        // 2:  bDescriptorSubType (OUTPUT_TERMINAL)
    0x03,                                        // 3:  bTerminalID
    0x01,                                        // 4:  bTerminalType(LSB) (Desktop SPEAKER)
    0x03,                                        // 5:  bTerminalType(MSB)
    0x00,                                        // 6:  bAssocTerminal     (No association)
    0x06,                                        // 7:  bSourceID          (bInputTerminalID)
    0x00                                         // 8:  iTerminal          (Unused)
  };
  
//-----Output Terminal Descriptor-----//
code BYTE OUTPUT_TERMINAL_USB_DESCRIPTOR[]=
  { 0x09,                                        // 0:  bLength
    0x24,                                        // 1:  bDescriptorType    (CS_INTERFACE)
    0x03,                                        // 2:  bDescriptorSubType (OUTPUT_TERMINAL)
    0x04,                                        // 3:  bTerminalID
    0x01,                                        // 4:  bTerminalType(LSB) (USB Streaming)
    0x01,                                        // 5:  bTerminalType(MSB)
    0x00,                                        // 6:  bAssocTerminal     (No association)
    0x05,                                        // 7:  bSourceID          (bInputTerminalID)
    0x00                                         // 8:  iTerminal          (Unused)
  };

//-----Selector Unit Descriptor-----//
code BYTE SELECTOR_UNIT_DESCRIPTOR[]=
  { 0x07,                                        // 0:  bLength
    0x24,                                        // 1:  bDescriptorType    (CS_ENDPOINT)
    0x05,                                        // 2:  bDescriptorSubType (Selector Unit)
    0x05,                                        // 3:  bUnitID
    0x01,                                        // 4:  bNrInPins
    0x07,                                        // 5:  baSourceID[1]
    0x00                                         // 6:  iSelector
  };

//-----Feature Unit Descriptor-----//
code BYTE Feature_Unit6_DESCRIPTOR[]=
  { 0x0D,                                        // 0:  bLength
    0x24,                                        // 1:  bDescriptorType    (CS_INTERFACE)
    0x06,                                        // 2:  bDescriptorSubType (FEATURE_UNIT)
    0x06,                                        // 3:  bUnitID
    0x09,                                        // 4:  bSourceID          (bInputTerminalID)
    0x02,                                        // 5:  bControlSize       (2 Byte)
    0x15,                                        // 6:  bmaControls/Master (Mute/Bass/Treble)
    0x01,                                        // 7:  Bass Boost
    0x02,                                        // 8:  bmaControls/Logical0(Volume)
    0x00,
    0x02,                                        // A:  bmaControls/Logical1(Volume)
    0x00,
    0x00                                         // C:  iFeature           (String Index)
  };

//-----Feature Unit Descriptor-----//
code BYTE Feature_Unit7_DESCRIPTOR[]=
  { 0x08,                                        // 0:  bLength
    0x24,                                        // 1:  bDescriptorType    (CS_INTERFACE)
    0x06,                                        // 2:  bDescriptorSubType (FEATURE_UNIT)
    0x07,                                        // 3:  bUnitID
    0x02,                                        // 4:  bSourceID          (bInputTerminalID)
    0x01,                                        // 5:  bControlSize       (1 Byte)
    0x03,                                        // 6:  bmaControls/Master (Mute/Volume)
    0x00                                         // C:  iFeature           (String Index)
  };

//-----Feature Unit Descriptor-----//
code BYTE Feature_Unit8_DESCRIPTOR[]=
  { 0x08,                                        // 0:  bLength
    0x24,                                        // 1:  bDescriptorType    (CS_INTERFACE)
    0x06,                                        // 2:  bDescriptorSubType (FEATURE_UNIT)
    0x08,                                        // 3:  bUnitID
    0x02,                                        // 4:  bSourceID          (bInputTerminalID)
    0x01,                                        // 5:  bControlSize       (1 Byte)
    0x03,                                        // 6:  bmaControls/Master (Mute/Volume)
    0x00                                         // C:  iFeature           (String Index)
  };

//-----Mixer Unit Descriptor-----//
code BYTE Mixer_Unit_DESCRIPTOR[]=
  { 0x0D,                                        // 0:  bLength
    0x24,                                        // 1:  bDescriptorType    (CS_INTERFACE)
    0x04,                                        // 2:  bDescriptorSubType (MIXER_UNIT)
    0x09,                                        // 3:  bUnitID
    0x02,                                        // 4:  bNrInputPins
    0x01,                                        // 5:  bSourceID[1]
    0x08,                                        // 6:  bSourceID[2]
    0x02,                                        // 7:  bNrChannels        (Two Channel)
    0x03,                                        // 8:  wChannelConfig(LSB)(Left , Right)
    0x00,                                        // 9:  wChannelConfig(MSB)
    0x00,                                        // A:  iChannelName       (Unused)
    0x00,                                        // B:  bmaControls        (Non-programmable)
    0x00                                         // C:  iMixer             (String Index)
  };
  
//-----Standard AS Interface Descriptor-----//
code BYTE OUT_STD_AS_INTERFACE_DESCRIPTOR[]=
  { 0x09,                                        // 0:  bLength
    0x04,                                        // 1:  bDescriptorType
    0x02,                                        // 2:  bInterfaceNumber
    0x00,                                        // 3:  bAlternateSetting
    0x00,                                        // 4:  bNumEndpoints
    0x01,                                        // 5:  bInterfaceClass    (AUDIO)
    0x02,                                        // 6:  bInterfaceSubClass (AUDIO-STREAMING)
    0x00,                                        // 7:  bInterfaceProtocol (Unused)
    0x00                                         // 8:  iInterface         (Unused)
  };


//-----Standard AS Alternate Interface Descriptor-----//
code BYTE OUT_STD_AS_ALT_INTERFACE_DESCRIPTOR[]=
  { 0x09,                                        // 0:  bLength
    0x04,                                        // 1:  bDescriptorType
    0x02,                                        // 2:  bInterfaceNumber
    0x01,                                        // 3:  bAlternateSetting
    0x01,                                        // 4:  bNumEndpoints
    0x01,                                        // 5:  bInterfaceClass    (AUDIO)
    0x02,                                        // 6:  bInterfaceSubClass (AUDIO-STREAMING)
    0x00,                                        // 7:  bInterfaceProtocol (Unused)
    0x00                                         // 8:  iInterface         (Unused)
  };


//-----Class_Specific AS Interface Descriptor-----//
code BYTE OUT_CS_AS_INTERFACE_DESCRIPTOR[]=
  { 0x07,                                        // 0:  bLength
    0x24,                                        // 1:  bDescriptorType    (CS_INTERFACE)
    0x01,                                        // 2:  bDescriptorSubType (AS_GENERAL)
    0x01,                                        // 3:  bTerminalLink      (INPUT Terminal ID)
    0x01,                                        // 4:  bDelay(ms)
    0x01,                                        // 5:  wFormatTag(LSB)    (PCM Format)
    0x00                                         // 6:  wFormatTag(MSB)
  };


//-----Format Type Descriptor-----//
code BYTE OUT_FORMAT_TYPE_DESCRIPTOR[]=
  { 0x0B,                                        // 0:  bLength
    0x24,                                        // 1:  bDescriptorType    (CS_INTERFACE)
    0x02,                                        // 2:  bDescriptorSubType (FORMAT_TYPE)
    0x01,                                        // 3:  bFormatType        (FORMAT_TYPE_I)
#ifdef SD_SO    
    0x02,                                        // 4:  bNrChannels        (Two Channel)
#endif
#ifdef SD_MO    
    0x01,                                        // 4:  bNrChannels        (One Channel)
#endif
    0x02,                                        // 5:  SubFrameSize       (Two Byte)
    0x10,                                        // 6:  bBitResolution     (16 bits)
    0x01,                                        // 7:  bSamFreqType       (One Sampling Freq.)
#ifdef SF_48K    
    0x80,                                        // 8:  tSamFreq(LSB)
    0xBB,                                        // 9:  tSamFreq(MSB)
    0x00                                         // A:  tSamFreq(HSB)
#endif
#ifdef SF_32K    
    0x00,                                        // 8:  tSamFreq(LSB)
    0x7D,                                        // 9:  tSamFreq(MSB)
    0x00                                         // A:  tSamFreq(HSB)
#endif
#ifdef SF_24K    
    0xC0,                                        // 8:  tSamFreq(LSB)
    0x5D,                                        // 9:  tSamFreq(MSB)
    0x00                                         // A:  tSamFreq(HSB)
#endif
#ifdef SF_16K    
    0x80,                                        // 8:  tSamFreq(LSB)
    0x3E,                                        // 9:  tSamFreq(MSB)
    0x00                                         // A:  tSamFreq(HSB)
#endif
#ifdef SF_12K    
    0xE0,                                        // 8:  tSamFreq(LSB)
    0x2E,                                        // 9:  tSamFreq(MSB)
    0x00                                         // A:  tSamFreq(HSB)
#endif
#ifdef SF_8K    
    0x40,                                        // 8:  tSamFreq(LSB)
    0x1F,                                        // 9:  tSamFreq(MSB)
    0x00                                         // A:  tSamFreq(HSB)
#endif
#ifdef SF_44_1K    
    0x44,                                        // 8:  tSamFreq(LSB)
    0xAC,                                        // 9:  tSamFreq(MSB)
    0x00                                         // A:  tSamFreq(HSB)
#endif
#ifdef SF_22_05K    
    0x22,                                        // 8:  tSamFreq(LSB)
    0x56,                                        // 9:  tSamFreq(MSB)
    0x00                                         // A:  tSamFreq(HSB)
#endif
  };


//-----Standard Data Endpoints Descriptor-----//
code BYTE OUT_STD_DATA_ENDPOINT4_DESCRIPTOR[]=
  { 0x09,                                        // 0:  bLength
    0x05,                                        // 1:  bDescriptorType
    0x04,                                        // 2:  bEndpointerAddress
                                                 //      D7:     Direction (0:OUT, 1:IN)
                                                 //      D6..4:  Reserved  (reset to 0)
                                                 //      D3..0:  Endpoint Number(0000-1111)
    0x09,                                        // 3:  bmAttributes
                                                 //      D7..2:  Reserved (reset to 0)
                                                 //      D3..2:  Synchronization Type (01:Asynchronous,10:Adaptive,11:Synchronous)
                                                 //      D1..0:  Transfer Type (00:Control,01:Iso,02:Bulk,03:Int)
#ifdef SD_SO
  #ifdef SF_48K
    0xC0,                                        // 4:  wPacketSize(LSB)   (192Bytes)
  #endif
  #ifdef SF_32K
    0x80,                                        // 4:  wPacketSize(LSB)   (128Bytes)
  #endif 
  #ifdef SF_24K
    0x60,                                        // 4:  wPacketSize(LSB)   (96Bytes)
  #endif 
  #ifdef SF_16K
    0x40,                                        // 4:  wPacketSize(LSB)   (64Bytes)
  #endif 
  #ifdef SF_12K
    0x30,                                        // 4:  wPacketSize(LSB)   (48Bytes)
  #endif 
  #ifdef SF_8K
    0x20,                                        // 4:  wPacketSize(LSB)   (32Bytes)
  #endif 
  #ifdef SF_44_1K
    0xB4,                                        // 4:  wPacketSize(LSB)   (180Bytes)
  #endif 
  #ifdef SF_22_05K
    0x5C,                                        // 4:  wPacketSize(LSB)   (92Bytes)
  #endif
#endif
#ifdef SD_MO
  #ifdef SF_48K
    0x60,                                        // 4:  wPacketSize(LSB)   (96Bytes)
  #endif
  #ifdef SF_32K
    0x40,                                        // 4:  wPacketSize(LSB)   (64Bytes)
  #endif
  #ifdef SF_24K
    0x30,                                        // 4:  wPacketSize(LSB)   (48Bytes)
  #endif
  #ifdef SF_16K
    0x20,                                        // 4:  wPacketSize(LSB)   (32Bytes)
  #endif
  #ifdef SF_12K
    0x18,                                        // 4:  wPacketSize(LSB)   (24Bytes)
  #endif
  #ifdef SF_8K
    0x10,                                        // 4:  wPacketSize(LSB)   (16Bytes)
  #endif
  #ifdef SF_44_1K
    0x5A,                                        // 4:  wPacketSize(LSB)   (90Bytes)
  #endif
  #ifdef SF_22_05K
    0x2E,                                        // 4:  wPacketSize(LSB)   (46Bytes)
  #endif
#endif
    0x00,                                        //     wPacketSize(MSB)
    0x01,                                        // 6:  bInterval (Unit 1ms)
                                                 //      Isochronous Endpoint: 01
                                                 //      Interrupt Endpoint: 01-ff
    0x00,                                        // 7:  bRefresh           (Unused)
    0x00                                         // 8:  bSynchAddress      (Unused)
  };


//-----Class_Specific Data Endpoints Descriptor-----//
code BYTE OUT_CS_DATA_ENDPOINT4_DESCRIPTOR[]=
  { 0x07,                                        // 0:  bLength
    0x25,                                        // 1:  bDescriptorType    (CS_ENDPOINT)
    0x01,                                        // 2:  bDescriptorSubType (AS_GENERAL)
    0x01,                                        // 3:  bmAttributes
    0x01,                                        // 4:  bLockDelayUnits(0:Undefined,1:Milliseconds,2:Decoded PCM samples)
    0x01,                                        // 5:  wLockDelay(LSB)
    0x00                                         // 6:  wLockDelay(MSB)
  };


//-----Standard AS Interface Descriptor-----//
code BYTE IN_STD_AS_INTERFACE_DESCRIPTOR[]=
  { 0x09,                                        // 0:  bLength
    0x04,                                        // 1:  bDescriptorType
    0x03,                                        // 2:  bInterfaceNumber
    0x00,                                        // 3:  bAlternateSetting
    0x00,                                        // 4:  bNumEndpoints
    0x01,                                        // 5:  bInterfaceClass    (AUDIO)
    0x02,                                        // 6:  bInterfaceSubClass (AUDIO-STREAMING)
    0x00,                                        // 7:  bInterfaceProtocol (Unused)
    0x00                                         // 8:  iInterface         (Unused)
  };


//-----Standard AS Alternate Interface Descriptor-----//
code BYTE IN_STD_AS_ALT_INTERFACE_DESCRIPTOR[]=
  { 0x09,                                        // 0:  bLength
    0x04,                                        // 1:  bDescriptorType
    0x03,                                        // 2:  bInterfaceNumber
    0x01,                                        // 3:  bAlternateSetting
    0x01,                                        // 4:  bNumEndpoints
    0x01,                                        // 5:  bInterfaceClass    (AUDIO)
    0x02,                                        // 6:  bInterfaceSubClass (AUDIO-STREAMING)
    0x00,                                        // 7:  bInterfaceProtocol (Unused)
    0x00                                         // 8:  iInterface         (Unused)
  };


//-----Class_Specific AS Interface Descriptor-----//
code BYTE IN_CS_AS_INTERFACE_DESCRIPTOR[]=
  { 0x07,                                        // 0:  bLength
    0x24,                                        // 1:  bDescriptorType    (CS_INTERFACE)
    0x01,                                        // 2:  bDescriptorSubType (AS_GENERAL)
    0x04,                                        // 3:  bTerminalLink      (OUTPUT Terminal ID)
    0x01,                                        // 4:  bDelay(ms)
    0x01,                                        // 5:  wFormatTag(LSB)    (PCM Format)
    0x00                                         // 6:  wFormatTag(MSB)
  };


//-----Format Type Descriptor-----//
code BYTE IN_FORMAT_TYPE_DESCRIPTOR[]=
  { 0x0B,                                        // 0:  bLength
    0x24,                                        // 1:  bDescriptorType    (CS_INTERFACE)
    0x02,                                        // 2:  bDescriptorSubType (FORMAT_TYPE)
    0x01,                                        // 3:  bFormatType        (FORMAT_TYPE_I)
#ifdef SD_SI    
    0x02,                                        // 4:  bNrChannels        (Two Channel)
#endif
#ifdef SD_MI    
    0x01,                                        // 4:  bNrChannels        (One Channel)
#endif
    0x02,                                        // 5:  SubFrameSize       (Two Byte)
    0x10,                                        // 6:  bBitResolution     (16 bits)
    0x01,                                        // 7:  bSamFreqType       (One Sampling Freq.)
#ifdef SF_48K    
    0x80,                                        // 8:  tSamFreq(LSB)
    0xBB,                                        // 9:  tSamFreq(MSB)
    0x00                                         // A:  tSamFreq(HSB)
#endif
#ifdef SF_32K    
    0x00,                                        // 8:  tSamFreq(LSB)
    0x7D,                                        // 9:  tSamFreq(MSB)
    0x00                                         // A:  tSamFreq(HSB)
#endif
#ifdef SF_24K    
    0xC0,                                        // 8:  tSamFreq(LSB)
    0x5D,                                        // 9:  tSamFreq(MSB)
    0x00                                         // A:  tSamFreq(HSB)
#endif
#ifdef SF_16K    
    0x80,                                        // 8:  tSamFreq(LSB)
    0x3E,                                        // 9:  tSamFreq(MSB)
    0x00                                         // A:  tSamFreq(HSB)
#endif
#ifdef SF_12K    
    0xE0,                                        // 8:  tSamFreq(LSB)
    0x2E,                                        // 9:  tSamFreq(MSB)
    0x00                                         // A:  tSamFreq(HSB)
#endif
#ifdef SF_8K    
    0x40,                                        // 8:  tSamFreq(LSB)
    0x1F,                                        // 9:  tSamFreq(MSB)
    0x00                                         // A:  tSamFreq(HSB)
#endif
#ifdef SF_44_1K    
    0x44,                                        // 8:  tSamFreq(LSB)
    0xAC,                                        // 9:  tSamFreq(MSB)
    0x00                                         // A:  tSamFreq(HSB)
#endif
#ifdef SF_22_05K    
    0x22,                                        // 8:  tSamFreq(LSB)
    0x56,                                        // 9:  tSamFreq(MSB)
    0x00                                         // A:  tSamFreq(HSB)
#endif
  };


//-----Standard Data Endpoints Descriptor-----//
code BYTE IN_STD_DATA_ENDPOINT5_DESCRIPTOR[]=
  { 0x09,                                        // 0:  bLength
    0x05,                                        // 1:  bDescriptorType
    0x85,                                        // 2:  bEndpointerAddress
                                                 //      D7:     Direction (0:OUT, 1:IN)
                                                 //      D6..4:  Reserved  (reset to 0)
                                                 //      D3..0:  Endpoint Number(0000-1111)
    0x05,                                        // 3:  bmAttributes
                                                 //      D7..2:  Reserved (reset to 0)
                                                 //      D3..2:  Synchronization Type (01:Asynchronous,10:Adaptive,11:Synchronous)
                                                 //      D1..0:  Transfer Type (00:Control,01:Iso,02:Bulk,03:Int)
#ifdef SD_SI
  #ifdef SF_48K
    0xC0,                                        // 4:  wPacketSize(LSB)   (192Bytes)
  #endif
  #ifdef SF_32K
    0x80,                                        // 4:  wPacketSize(LSB)   (128Bytes)
  #endif 
  #ifdef SF_24K
    0x60,                                        // 4:  wPacketSize(LSB)   (96Bytes)
  #endif 
  #ifdef SF_16K
    0x40,                                        // 4:  wPacketSize(LSB)   (64Bytes)
  #endif 
  #ifdef SF_12K
    0x30,                                        // 4:  wPacketSize(LSB)   (48Bytes)
  #endif 
  #ifdef SF_8K
    0x20,                                        // 4:  wPacketSize(LSB)   (32Bytes)
  #endif 
  #ifdef SF_44_1K
    0xB4,                                        // 4:  wPacketSize(LSB)   (180Bytes)
  #endif 
  #ifdef SF_22_05K
    0x5C,                                        // 4:  wPacketSize(LSB)   (92Bytes)
  #endif
#endif
#ifdef SD_MI
  #ifdef SF_48K
    0x60,                                        // 4:  wPacketSize(LSB)   (96Bytes)
  #endif
  #ifdef SF_32K
    0x40,                                        // 4:  wPacketSize(LSB)   (64Bytes)
  #endif
  #ifdef SF_24K
    0x30,                                        // 4:  wPacketSize(LSB)   (48Bytes)
  #endif
  #ifdef SF_16K
    0x20,                                        // 4:  wPacketSize(LSB)   (32Bytes)
  #endif
  #ifdef SF_12K
    0x18,                                        // 4:  wPacketSize(LSB)   (24Bytes)
  #endif
  #ifdef SF_8K
    0x10,                                        // 4:  wPacketSize(LSB)   (16Bytes)
  #endif
  #ifdef SF_44_1K
    0x5A,                                        // 4:  wPacketSize(LSB)   (90Bytes)
  #endif
  #ifdef SF_22_05K
    0x2E,                                        // 4:  wPacketSize(LSB)   (46Bytes)
  #endif
#endif

    0x00,                                        //     wPacketSize(MSB)
    0x01,                                        // 6:  bInterval (Unit 1ms)
                                                 //      Isochronous Endpoint: 01
                                                 //      Interrupt Endpoint: 01-ff
    0x00,                                        // 7:  bRefresh           (Unused)
    0x00                                         // 8:  bSynchAddress      (Unused)
  };


//-----Class_Specific Data Endpoints Descriptor-----//
code BYTE IN_CS_DATA_ENDPOINT5_DESCRIPTOR[]=
  { 0x07,                                        // 0:  bLength
    0x25,                                        // 1:  bDescriptorType    (CS_ENDPOINT)
    0x01,                                        // 2:  bDescriptorSubType (AS_GENERAL)
    0x01,                                        // 3:  bmAttributes
    0x00,                                        // 4:  bLockDelayUnits(0:Undefined,1:Milliseconds,2:Decoded PCM samples)
    0x00,                                        // 5:  wLockDelay(LSB)
    0x00                                         // 6:  wLockDelay(MSB)
  };


code BYTE LANGUAGEID_DESCRIPTOR[]=
  { 0x04,					 // Computed by subtraction two from the value of the first byte of the descriptor
    0x03, 					 // Descriptor Type
    0x09,
    0x04
  };


#define MFS_LEN sizeof("SMART Sonifi")*2
//-----MANUFACTURER(UNICODE) in String Descriptor-----//
code BYTE MANUFACTURER_DESCRIPTOR[]=
  { MFS_LEN,
    0x03,                                        // Descriptor Type
    'S',0x00,
    'M',0x00,
    'A',0x00,
    'R',0x00,
    'T',0x00,
    ' ',0x00,
    'S',0x00,
    'o',0x00,
    'n',0x00,
    'i',0x00,
    'f',0x00,
    'i',0x00
  };


#define PDS_LEN sizeof("USB Audio Device")*2
//-----PRODUCT(UNICODE) in String Descriptor-----//
code BYTE PRODUCT_DESCRIPTOR[]=
  { PDS_LEN,
    0x03,                                        // Descriptor Type
    'U',0x00,
    'S',0x00,
    'B',0x00,
    ' ',0x00,
    'A',0x00,
    'u',0x00,
    'd',0x00,
    'i',0x00,
    'o',0x00,
    ' ',0x00,
    'D',0x00,
    'e',0x00,
    'v',0x00,
    'i',0x00,
    'c',0x00,
    'e',0x00
  };


#define SNS_LEN sizeof("621031")*2
//-----Serial Number in String Descriptor-----//
code BYTE SERIALNUMBER_DESCRIPTOR[]=
  { SNS_LEN,
    0x03,                                        // Descriptor Type
    '6',0x00,
    '2',0x00,
    '1',0x00,
    '0',0x00,
    '3',0x00,
    '1',0x00
  };


/*
//-----PRODUCT(UNICODE) in String Descriptor-----//
code BYTE MANUFACTURER_DESCRIPTOR[]=
  { 0x2E,0x03,0x4D,0x00,0x65,0x00,0x67,0x00,     // Megawin Technology Inc.
    0x61,0x00,0x77,0x00,0x69,0x00,0x6E,0x00,
    0x20,0x00,0x54,0x00,0x65,0x00,0x63,0x00,
    0x68,0x00,0x6E,0x00,0x6F,0x00,0x6C,0x00,
    0x6F,0x00,0x67,0x00,0x79,0x00,0x20,0x00,
    0x49,0x00,0x6E,0x00,0x63,0x00
  };


//-----PRODUCT(UNICODE) in String Descriptor-----//
code BYTE PRODUCT_DESCRIPTOR[]=
  { 0x32,0x03,'U',0x00,'S',0x00,'B',0x00,
    ' ',0x00,'A',0x00,'u',0x00,'d',0x00,
    'i',0x00,'o',0x00,' ',0x00,'D',0x00,
    'e',0x00,'v',0x00,'i',0x00,'c',0x00,
    'e',0x00,'-',0x00,'W',0x00,'o',0x00,
    'l',0x00,'f',0x00,'S',0x00,'o',0x00,
    'n',0x00
  }; 


//-----PRODUCT(UNICODE) in String Descriptor-----//
code BYTE MANUFACTURER_DESCRIPTOR[]=
  { 0x30,0x03,'C',0x00,'O',0x00,'T',0x00,
    'R',0x00,'O',0x00,'N',0x00,' ',0x00,
    'C',0x00,'O',0x00,'R',0x00,'P',0x00,
    'O',0x00,'R',0x00,'A',0x00,'T',0x00,
    'I',0x00,'O',0x00,'N',0x00,' ',0x00,
    'L',0x00,'t',0x00,'d',0x00,'.',0x00
  };


//-----PRODUCT(UNICODE) in String Descriptor-----//
code BYTE PRODUCT_DESCRIPTOR[]=
  { 0x22,0x03,'U',0x00,'S',0x00,'B',0x00,
    ' ',0x00,'A',0x00,'u',0x00,'d',0x00,
    'i',0x00,'o',0x00,' ',0x00,'D',0x00,
    'e',0x00,'v',0x00,'i',0x00,'c',0x00,
    'e',0x00
  }; 

//-----Serial Number in String Descriptor-----//
code BYTE SERIALNUMBER_DESCRIPTOR[]=
  { 0x0E,
    0x03, 					 // Descriptor Type
    0x36,0x00,0x32,0x00,
    0x31,0x00,0x30,0x00,
    0x33,0x00,0x31,0x00
  };
*/